ORCA/M Asm65816 2.1.0

0001 CC4E                       title 'Tool Locator--Mount' 
0002 CC4E              ****************************************************************************
0003 CC4E              *                                                                          *
0004 CC4E              *                                  Mount                                   *
0005 CC4E              *                                                                          *
0006 CC4E              ****************************************************************************
0007 CC4E
0008 CC4E
0009 CC4E              ****************************************************************************
0010 CC4E              *
0011 CC4E              *                   CopyRight Apple Computer, Inc. 1985-1989
0012 CC4E              *                   All Rights Reserved
0013 CC4E              *
0014 CC4E              *
0015 CC4E              * 21 Feb 89         Harry Yee
0016 CC4E              *
0017 CC4E              * Fixed problem in TLTextMountVolume and TLMountVolume. Before we were calling  
0018 CC4E              * GetNextEvent which caused problems if there happened to be a system window 
0019 CC4E              * beneath us. Key downs and mouse downs were never getting back to the tool locator    
0020 CC4E              * because they were passed onto the Desk Mgr via SystemEvent. Now I call GetOSEvent  
0021 CC4E              * which doesn't call the Desk Mgr and if there was a desk accessary event 
0022 CC4E              * i.e. <ctrl><open-apple><esc> I pass on this event to the Desk Mgr myself 
0023 CC4E              * via SystemEvent. BRC #41721. 
0024 CC4E              *
0025 CC4E              * Also for TLTextMountVolume we were not taking mouse downs or mouse ups. This
0026 CC4E              * caused problems if the user was clicking the mouse while in the text screen because
0027 CC4E              * when they finally returned to the program all the mouse events would be queued up.
0028 CC4E              * I now take mouse events and just discard them.
0029 CC4E              *
0030 CC4E              ****************************************************************************
0031 CC4E
0032 CC4E
0033 CC4E                       blanks off 
0034 CC4E                       string asis 
0035 CC4E
0036 CC4E                       print push 
0037 CC4E                       print off 
0038 CC4E                       include 'all.macros' 
0039 CC4E                       include '::sys.equs.asm' 
0040 CC4E                       INCLUDE 'e16.memory' 
0041 CC4E                       include 'e16.event' 
0042 CC4E
0043 CC4E                       include 'tl.equates.asm' 
0044 CC4E                       print pop 
0045 CC4E
0046 CC4E
0047 CC4E
0048 CC4E
0049 CC4E                       title ' Imported Addresses' 
0050 CC4E              ;-----------------------------------------------
0051 CC4E              ;
0052 CC4E              ;   Imported addresses
0053 CC4E              ;
0054 CC4E              ;-----------------------------------------------
0055 CC4E
0056 CC4E                       IMPORT EndCall4 
0057 CC4E                       IMPORT EndCall8 
0058 CC4E                       IMPORT ErrOut4 
0059 CC4E                       IMPORT ErrOut8 
0060 CC4E                       IMPORT oBusyErr4 
0061 CC4E                       IMPORT oEndCall0 
0062 CC4E
0063 CC4E                       eject 
0064 CC4E              ****************************************************************
0065 CC4E              *
0066 CC4E              TLMountVolume PROC EXPORT 
0067 CC4E              *
0068 CC4E              * This is the mount volume call that is part of the tool
0069 CC4E              * locator.  Why is it part of the tool locator?  A very good
0070 CC4E              * question.  It is part of the tool locator because it
0071 CC4E              * needs to be loaded and stay loaded when other tools
0072 CC4E              * cannot be loaded.
0073 CC4E              *
0074 CC4E              * For example, an application calls load tools which fails
0075 CC4E              * because the the boot volume is not on line.  The application
0076 CC4E              * cannot call a tool that is not loaded to tell the user to
0077 CC4E              * insert the disk.
0078 CC4E              *
0079 CC4E              * So this routine does this work for the desk top application.
0080 CC4E              * It does not do the work for a text, lo res or hi-res
0081 CC4E              * application.  Such routines are left as exercises to the
0082 CC4E              * application writer.
0083 CC4E              *
0084 CC4E              * Assumptions:
0085 CC4E              *
0086 CC4E              *     1) QuickDraw is already initialized so I can safely make
0087 CC4E              *        QuickDraw calls.
0088 CC4E              *     2) Event Manager is already initialized so I can safely
0089 CC4E              *        make Event manager calls.
0090 CC4E              *     3) Memory will be available.
0091 CC4E              *
0092 CC4E              *
0093 CC4E              * This routine actually makes no OS calls.  It just returns
0094 CC4E              * the button number pressed by the user.  The application
0095 CC4E              * then can make the call that failed again and see if it
0096 CC4E              * works.
0097 CC4E              *
0098 CC4E              * By not guarenteeing the volume is mounted this routine is
0099 CC4E              * more general (and shorter).
0100 CC4E              *
0101 CC4E              *
0102 CC4E              *
0103 CC4E              * Inputs:
0104 CC4E              *              WhereX : word
0105 CC4E              *              WhereY : word
0106 CC4E              *              PromptPtr : long
0107 CC4E              *              VolPtr : long
0108 CC4E              *              OKPtr : long
0109 CC4E              *              CancelPtr : long
0110 CC4E              *
0111 CC4E              * Outputs:
0112 CC4E              *              ButtonSelected : word
0113 CC4E              *
0114 CC4E              * External Refs:
0115 CC4E                       import TLGetMem2 
0116 CC4E              *
0117 CC4E              * Entry Points:
0118 CC4E              *                   none
0119 CC4E              *
0120 CC4E                       longa on                       ; mode
0121 CC4E                       longi on
0122 CC4E              *
0123 CC4E              * Change History
0124 CC4E              *
0125 CC4E              * 17 Jun 88         Steven Glass
0126 CC4E              *
0127 CC4E              * Removed internal copy of TLGetMem and used the global version.
0128 CC4E              * Why we had a separate copy, I don't know.
0129 CC4E              *
0130 CC4E              *
0131 CC4E              * 06 Jan 89         Steven Glass
0132 CC4E              *
0133 CC4E              * Added error checking to routines that allocate memory.  If
0134 CC4E              * error occurs, we try to call TLTextMountVolume.
0135 CC4E              *
0136 CC4E              ****************************************************************
0137 CC4E
0138 CC4E              ;
0139 CC4E              ; Equates for dialog
0140 CC4E              ;
0141 CC4E
0142 CC4E              DialogWidth equ   280
0143 CC4E              DialogHeight equ   65
0144 CC4E              ButWidth equ   115
0145 CC4E              ButHeight equ   13
0146 CC4E              Size320  equ   DialogHeight*(8+DialogWidth)/2
0147 CC4E              Size640  equ   DialogHeight*(16+DialogWidth)/4
0148 CC4E              Width320 equ   2+(DialogWidth/2)
0149 CC4E              Width640 equ   4+(DialogWidth/4)
0150 CC4E              LeftFace equ   15
0151 CC4E              PromptX  equ   LeftFace
0152 CC4E              PromptY  equ   15
0153 CC4E              VolX     equ   LeftFace
0154 CC4E              VolY     equ   30
0155 CC4E              TopFace  equ   22                       ; space from bottom of dialog to
0156 CC4E              OKy      equ   DialogHeight-TopFace+ButHeight-3
0157 CC4E              Cancely  equ   DialogHeight-TopFace+ButHeight-3
0158 CC4E
0159 CC4E
0160 CC4E
0161 CC4E
0162 CC4E
0163 CC4E              ;
0164 CC4E              ; Local Data
0165 CC4E              ;
0166 CC4E                       DefineStack 
0167 CC4E
0168 CC4E              SaveHandle long 
0169 CC4E
0170 CC4E              EvtWhat  word 
0171 CC4E              EvtMessage long 
0172 CC4E              EvtWhen  long 
0173 CC4E              EvtWhere long 
0174 CC4E              EvtModifiers word 
0175 CC4E              TheEvent equ   EvtWhat
0176 CC4E
0177 CC4E              OrigPort long 
0178 CC4E              SizeofSaveSpace long                    ; this is size of handle
0179 CC4E              MountPortHandle long 
0180 CC4E              MountPortPtr long 
0181 CC4E
0182 CC4E              SaveSCB  word                           ; ds 2
0183 CC4E              PtrToSaveSpace long                     ; ds 4           ; pointer to memory
0184 CC4E              SaveWidth word                          ; ds 2
0185 CC4E              SaveBounds block 8                      ; dc i'0,0,200,640'
0186 CC4E              SaveLocInfo equ   SaveSCB
0187 CC4E
0188 CC4E              SrcRect  block 8 
0189 CC4E              DialogRect equ   SrcRect
0190 CC4E
0191 CC4E              InnerDRect block 8 
0192 CC4E
0193 CC4E              HLRect   block 8 
0194 CC4E              HiliteFlag word 
0195 CC4E
0196 CC4E              WhichButton word 
0197 CC4E
0198 CC4E
0199 CC4E              OrigD    word 
0200 CC4E
0201 CC4E              ; Stack on entry
0202 CC4E              ;
0203 CC4E              RTL1     block 3 
0204 CC4E              RTL2     block 3 
0205 CC4E              CancelPtr long 
0206 CC4E              OKPtr    long 
0207 CC4E              VolPtr   long 
0208 CC4E              PromptPtr long 
0209 CC4E              WhereY   word 
0210 CC4E              WhereX   word 
0211 CC4E              Result   word 
0212 CC4E
0213 CC4E              SizeLocals equ   OrigD-1
0214 CC4E
0215 CC4E                       eject 
0216 CC4E
0217 CC4E 0B                    phd   
0218 CC4F 3B                    tsc   
0219 CC50 38                    sec   
0220 CC51 E9 50 00              sbc   #SizeLocals
0221 CC54 1B                    tcs   
0222 CC55 5B                    tcd   
0223 CC56
0224 CC56 8B                    phb   
0225 CC57 4B                    phk   
0226 CC58 AB                    plb   
0227 CC59
0228 CC59 22 64 00 E1           jsl   IncBusyFlg
0229 CC5D
0230 CC5D 48                    pha   
0231 CC5E 48                    pha   
0232 CC5F A2 04 1C 22           _GetPort 
0233 CC66
0234 CC66
0235 CC66 A9 B4 00              lda   #180
0236 CC69 A2 00 C0              ldx   #$C000                   ; locked and fixed
0237 CC6C 20 E6 D2              jsr   TLGetMem2
0238 CC6F 90 03                 bcc   @2
0239 CC71 82 89 01              brl   MemError1
0240 CC74              @2        
0241 CC74
0242 CC74 85 1D                 sta   MountPortHandle
0243 CC76 86 1F                 stx   MountPortHandle+2
0244 CC78 A7 1D                 lda   [MountPortHandle]
0245 CC7A 85 21                 sta   MountPortPtr
0246 CC7C A0 02 00              ldy   #2
0247 CC7F B7 1D                 lda   [MountPortHandle],y
0248 CC81 85 23                 sta   MountPortPtr+2
0249 CC83
0250 CC83 D4 23                 pei   MountPortPtr+2
0251 CC85 D4 21                 pei   MountPortPtr
0252 CC87 A2 04 18 22           _OpenPort 
0253 CC8E 90 03                 bcc   @1
0254 CC90 82 67 01              brl   PortError
0255 CC93              @1        
0256 CC93
0257 CC93              ;------------------------------------------------------
0258 CC93              ;
0259 CC93              ; First I need to figure out how big the rectangle
0260 CC93              ; that will be saved is so I can get a handle for it.
0261 CC93              ;
0262 CC93 A7 21                 lda   [MountPortPtr]
0263 CC95 85 25                 sta   SaveSCB                  ; put this in the save LocInfo
0264 CC97 29 80 00              and   #$0080
0265 CC9A F0 0A                 beq   Mode320
0266 CC9C
0267 CC9C A9 4A 00              lda   #Width640
0268 CC9F 85 2B                 sta   SaveWidth
0269 CCA1 A9 CA 12              lda   #Size640
0270 CCA4 80 08                 bra   GotSize
0271 CCA6
0272 CCA6 A9 8E 00     Mode320  lda   #Width320
0273 CCA9 85 2B                 sta   SaveWidth
0274 CCAB A9 90 24              lda   #Size320
0275 CCAE
0276 CCAE 85 19        GotSize  sta   SizeofSaveSpace
0277 CCB0 64 1B                 stz   SizeofSaveSpace+2
0278 CCB2
0279 CCB2
0280 CCB2              ;-------------------------------------------------
0281 CCB2              ;
0282 CCB2              ; Fix SaveLocInfo's bounds rect.  This bounds
0283 CCB2              ; rect is identical to the destrect.
0284 CCB2              ;
0285 CCB2 A0 A9 D0              ldy   #DestRect
0286 CCB5 A2 2D 00              ldx   #SaveBounds
0287 CCB8 20 94 D0              jsr   MoveRect
0288 CCBB
0289 CCBB
0290 CCBB              ;------------------------------------------------------
0291 CCBB              ;
0292 CCBB              ; Set up important variables.  First SourceRect and
0293 CCBB              ; InnerDRect are calculated from WhereX, WhereY and
0294 CCBB              ; size contants.  InnerDRect is then calculated by
0295 CCBB              ; inseting its initial value.
0296 CCBB              ;
0297 CCBB A5 6B                 lda   WhereX
0298 CCBD 85 37                 sta   SrcRect+2
0299 CCBF 85 3F                 sta   InnerDRect+2
0300 CCC1 18                    clc   
0301 CCC2 69 18 01              adc   #DialogWidth
0302 CCC5 85 3B                 sta   SrcRect+6
0303 CCC7 85 43                 sta   InnerDRect+6
0304 CCC9
0305 CCC9 A5 69                 lda   WhereY
0306 CCCB 85 35                 sta   SrcRect
0307 CCCD 85 3D                 sta   InnerDRect
0308 CCCF 18                    clc   
0309 CCD0 69 41 00              adc   #DialogHeight
0310 CCD3 85 39                 sta   SrcRect+4
0311 CCD5 85 41                 sta   InnerDRect+4
0312 CCD7
0313 CCD7 A9 3D 00              lda   #InnerDRect
0314 CCDA 20 4B CE              jsr   PushDP
0315 CCDD 20 58 CE              jsr   WhichMode
0316 CCE0 F0 05                 beq   Inset320
0317 CCE2 F4 04 00              PushWord #4 
0318 CCE5 80 03                 bra   ContInset
0319 CCE7 F4 02 00     Inset320 PushWord #2 
0320 CCEA F4 02 00     ContInset PushWord #2 
0321 CCED A2 04 4C 22           _InsetRect 
0322 CCF4
0323 CCF4
0324 CCF4              ;------------------------------------------------------
0325 CCF4              ;
0326 CCF4              ; Get memory for the pixels being saved.
0327 CCF4              ;
0328 CCF4 A5 19                 lda   SizeOfSaveSpace
0329 CCF6 A2 00 80              ldx   #$8000                   ; locked
0330 CCF9 20 E6 D2              jsr   TLGetMem2
0331 CCFC 90 03                 bcc   @3
0332 CCFE 82 F6 00              brl   MemError2
0333 CD01              @3        
0334 CD01 85 01                 sta   SaveHandle
0335 CD03 86 03                 stx   SaveHandle+2
0336 CD05 A7 01                 lda   [SaveHandle]
0337 CD07 85 27                 sta   PtrToSaveSpace
0338 CD09 A0 02 00              ldy   #2
0339 CD0C B7 01                 lda   [SaveHandle],y
0340 CD0E 85 29                 sta   PtrToSaveSpace+2
0341 CD10
0342 CD10
0343 CD10 A2 04 90 22           _HideCursor                    ; hide cursor to avoid stamping
0344 CD17
0345 CD17
0346 CD17 F4 00 00 F4           PushLong #0                    ; build parameter block on the
0347 CD1D F4 00 00              PushWord #0                    ; stack for PaintPixels
0348 CD20 F4 FD 00 F4           PushLong #DestRect 
0349 CD26 A9 35 00              lda   #SrcRect                 ; we build it backwards.
0350 CD29 20 4B CE              jsr   PushDP
0351 CD2C A9 25 00              lda   #SaveLocInfo
0352 CD2F 20 4B CE              jsr   PushDP
0353 CD32 D4 23                 pei   MountPortPtr+2
0354 CD34 D4 21                 pei   MountPortPtr
0355 CD36 20 32 CE              jsr   Paint
0356 CD39
0357 CD39 A2 04 91 22           _ShowCursor 
0358 CD40
0359 CD40 A9 35 00              lda   #DialogRect              ; pointer to DialogRect
0360 CD43 20 4B CE              jsr   PushDP
0361 CD46 A2 04 55 22           _EraseRect 
0362 CD4D
0363 CD4D 20 58 CE              jsr   WhichMode
0364 CD50 F0 05                 beq   PS320
0365 CD52 F4 02 00              PushWord #2 
0366 CD55 80 03                 bra   FiniPenSize
0367 CD57 F4 01 00     PS320    PushWord #1 
0368 CD5A F4 01 00     FiniPenSize PushWord #1 
0369 CD5D A2 04 2C 22           _SetPenSize 
0370 CD64
0371 CD64 A9 35 00              lda   #DialogRect
0372 CD67 20 4B CE              jsr   PushDP
0373 CD6A A2 04 53 22           _FrameRect 
0374 CD71
0375 CD71 A9 3D 00              lda   #InnerDRect
0376 CD74 20 4B CE              jsr   PushDP
0377 CD77 A2 04 53 22           _FrameRect 
0378 CD7E
0379 CD7E A9 35 00              lda   #DialogRect
0380 CD81 20 4B CE              jsr   PushDP
0381 CD84 A2 04 1F 22           _SetPortRect 
0382 CD8B
0383 CD8B F4 00 00              PushWord #0 
0384 CD8E F4 00 00              PushWord #0 
0385 CD91 A2 04 23 22           _SetOrigin 
0386 CD98
0387 CD98 20 4A D0              jsr   DrawDialog
0388 CD9B
0389 CD9B 20 5E CE              jsr   PlayWithIt               ; returns 1 for ok, 2 for cancel
0390 CD9E
0391 CD9E 85 6D                 sta   Result
0392 CDA0
0393 CDA0 D4 23                 pei   MountPortPtr+2           ; re init loc info in mount port
0394 CDA2 D4 21                 pei   MountPortPtr
0395 CDA4 A2 04 19 22           _InitPort 
0396 CDAB
0397 CDAB F4 00 00 F4           PushLong #0                    ; build parameter block on the
0398 CDB1 F4 00 00              PushWord #0                    ; stack for PaintPixels
0399 CDB4 A9 35 00              lda   #SrcRect                 ; we build it backwards.
0400 CDB7 20 4B CE              jsr   PushDP
0401 CDBA F4 FD 00 F4           PushLong #DestRect 
0402 CDC0 D4 23                 pei   MountPortPtr+2
0403 CDC2 D4 21                 pei   MountPortPtr
0404 CDC4 A9 25 00              lda   #SaveLocInfo
0405 CDC7 20 4B CE              jsr   PushDP
0406 CDCA 20 32 CE              jsr   Paint
0407 CDCD
0408 CDCD D4 03                 pei   SaveHandle+2             ; free the memory
0409 CDCF D4 01                 pei   SaveHandle
0410 CDD1 A2 02 10 22           _DisposeHandle 
0411 CDD8
0412 CDD8
0413 CDD8              GetOutHere  
0414 CDD8 A2 04 1B 22           _SetPort                       ; restore orig port
0415 CDDF
0416 CDDF 20 1A CE              jsr   ClosePort
0417 CDE2 20 26 CE              jsr   DisposePortHandle
0418 CDE5 AB                    plb   
0419 CDE6
0420 CDE6 3B                    tsc   
0421 CDE7 18                    clc   
0422 CDE8 69 50 00              adc   #SizeLocals
0423 CDEB 1B                    tcs   
0424 CDEC
0425 CDEC
0426 CDEC A0 14 00              ldy   #20
0427 CDEF A2 00 00              ldx   #0
0428 CDF2 2B                    pld   
0429 CDF3 5C 80 01 E1           jml   ToBusyStrip
0430 CDF7
0431 CDF7
0432 CDF7
0433 CDF7
0434 CDF7              ;
0435 CDF7              ; Got mem error trying to get buffer for bits.  This is 
0436 CDF7              ; after port allocated.  So close port and fall into other error
0437 CDF7              ; routines.
0438 CDF7              ;
0439 CDF7              MemError2  
0440 CDF7 20 1A CE              jsr   ClosePort
0441 CDFA              ;
0442 CDFA              ; Got error opening grafPort.
0443 CDFA              ;
0444 CDFA              PortError  
0445 CDFA 20 26 CE              jsr   DisposePortHandle
0446 CDFD
0447 CDFD              ;
0448 CDFD              ; Got error getting memory for port.  Boy are we in trouble now.
0449 CDFD              ;
0450 CDFD              MemError1  
0451 CDFD
0452 CDFD              ;
0453 CDFD              ; Try to call TLTextMountVolume and keep fingers crossed.
0454 CDFD              ;
0455 CDFD 48                    pha   
0456 CDFE D4 67                 pei   PromptPtr+2
0457 CE00 D4 65                 pei   PromptPtr
0458 CE02 D4 63                 pei   VolPtr+2
0459 CE04 D4 61                 pei   VolPtr
0460 CE06 D4 5F                 pei   OkPtr+2
0461 CE08 D4 5D                 pei   OkPtr
0462 CE0A D4 5B                 pei   CancelPtr+2
0463 CE0C D4 59                 pei   CancelPtr
0464 CE0E A2 01 12 22           _TLTextMountVolume 
0465 CE15 68                    pla   
0466 CE16 85 6D                 sta   Result
0467 CE18 80 BE                 bra   GetOutHere
0468 CE1A
0469 CE1A
0470 CE1A              ClosePort  
0471 CE1A D4 23                 pei   MountPortPtr+2           ; close our port
0472 CE1C D4 21                 pei   MountPortPtr
0473 CE1E A2 04 1A 22           _ClosePort 
0474 CE25 60                    rts   
0475 CE26
0476 CE26              DisposePortHandle  
0477 CE26 D4 1F                 pei   MountPortHandle+2
0478 CE28 D4 1D                 pei   MountPortHandle
0479 CE2A A2 02 10 22           _DisposeHandle 
0480 CE31 60                    rts   
0481 CE32
0482 CE32                       eject 
0483 CE32
0484 CE32              ;-------------------------------------------------
0485 CE32              ;
0486 CE32              ; Paint
0487 CE32              ;
0488 CE32              ; Calls paint pixels using PPParam block on stack
0489 CE32              ; just above the rts adr.
0490 CE32              ;
0491 CE32              ; After calling paint pixels, it strips 22 bytes
0492 CE32              ; off the stack.
0493 CE32              ;
0494 CE32
0495 CE32              Paint                                   ; 
0496 CE32              rtsadr   equ   1
0497 CE32              PPParams equ   3
0498 CE32 3B                    tsc   
0499 CE33 F4 00 00              pea   0000
0500 CE36 18                    clc   
0501 CE37 69 03 00              adc   #PPParams
0502 CE3A 48                    pha   
0503 CE3B A2 04 7F 22           _PaintPixels 
0504 CE42
0505 CE42 7A                    ply   
0506 CE43 3B                    tsc   
0507 CE44 18                    clc   
0508 CE45 69 16 00              adc   #22
0509 CE48 1B                    tcs   
0510 CE49 5A                    phy   
0511 CE4A
0512 CE4A 60                    rts   
0513 CE4B
0514 CE4B              ;-------------------------------------------------
0515 CE4B              ;
0516 CE4B              ; PushDP
0517 CE4B              ;
0518 CE4B              ; Pushes a long pointer to a value on direct page.
0519 CE4B              ; the offset on D is passed in the a-reg.
0520 CE4B              ;
0521 CE4B              ; Input:  a-reg    offset
0522 CE4B              ; Output: Stack
0523 CE4B              ;
0524 CE4B              ; Trashed:  a-reg
0525 CE4B              ;           x-reg
0526 CE4B              ; Preserved y-reg
0527 CE4B              ;
0528 CE4B              PushDP                                  ; 
0529 CE4B FA                    plx                            ; get rts off stack
0530 CE4C F4 00 00              pea   0000                     ; push hi word of 0
0531 CE4F 48                    pha                            ; get offset on D page onto stack
0532 CE50 7B                    tdc                            ; get dpage value
0533 CE51 18                    clc                            ; add to offset and
0534 CE52 63 01                 adc   1,s
0535 CE54 83 01                 sta   1,s                      ; overstore
0536 CE56 DA                    phx                            ; put back rts value
0537 CE57 60                    rts   
0538 CE58
0539 CE58
0540 CE58
0541 CE58                       eject 
0542 CE58              ;-------------------------------------------------
0543 CE58              ;
0544 CE58              ; WhichMode
0545 CE58              ;
0546 CE58              ; This routine returns 0 in the a-reg if the
0547 CE58              ; screen is in 320 mode and nonzero if it is
0548 CE58              ; in 640 mode.
0549 CE58              ;
0550 CE58              WhichMode                               ; 
0551 CE58 A7 21                 lda   [MountPortPtr]
0552 CE5A 29 80 00              and   #$0080
0553 CE5D 60                    rts   
0554 CE5E
0555 CE5E
0556 CE5E
0557 CE5E
0558 CE5E              ;-------------------------------------------------
0559 CE5E              ;
0560 CE5E              ; PlayWithIt
0561 CE5E              ;
0562 CE5E              ; This is the routine that gets events and waits for a
0563 CE5E              ; response from the user.
0564 CE5E              ;
0565 CE5E              PlayWithIt                              ; 
0566 CE5E
0567 CE5E              ;
0568 CE5E              ; --- The only events we want are MouseDown, MouseUp, KeyDown, AutoKeyDown and DeskAcc -------
0569 CE5E              ; 
0570 CE5E A9 2E 04              lda   #mDownMask+mUpMask+keyDownMask+autoKeyMask+deskAccMask
0571 CE61 20 86 CE              jsr   GetThisEvent
0572 CE64 F0 F8                 beq   PlayWithIt               ; no event of that type in queue so keep looking
0573 CE66
0574 CE66 A5 05                 lda   EvtWhat                  ; got something!
0575 CE68 0A                    asl   a
0576 CE69 AA                    tax   
0577 CE6A FC 70 CE              jsr   (EventTable,x)
0578 CE6D 90 EF                 bcc   PlayWithIt
0579 CE6F
0580 CE6F
0581 CE6F 60                    rts   
0582 CE70
0583 CE70
0584 CE70 CC CE        EventTable DC W:ignore
0585 CE72 AF CE                 DC W:DoMouseDown               ; 1
0586 CE74 CC CE                 DC W:ignore                    ; 2 mouse up
0587 CE76 1A D0                 DC W:DoKey                     ; 3
0588 CE78 CC CE                 DC W:ignore                    ; 4 undefined
0589 CE7A 1A D0                 DC W:DoKey                     ; 5 auto key
0590 CE7C CC CE                 DC W:ignore                    ; 6 update
0591 CE7E CC CE                 DC W:ignore                    ; 7 undefined
0592 CE80 CC CE                 DC W:ignore                    ; 8 activate 
0593 CE82 CC CE                 DC W:ignore                    ; 9 switch
0594 CE84 97 CE                 DC W:DoDeskAcc                 ; 10 deskAccEvt
0595 CE86
0596 CE86
0597 CE86                       eject 
0598 CE86              ;-------------------------------------------------
0599 CE86              ;
0600 CE86              ; GetThisEvent
0601 CE86              ;
0602 CE86              ; Called by PlayWithIt to read
0603 CE86              ; character using event manager.
0604 CE86              ;
0605 CE86              ; Event mask is passed in a-reg.  boolean returned in a reg.
0606 CE86              ;
0607 CE86              GetThisEvent                            ; 
0608 CE86 48                    pha                            ; space for result
0609 CE87 48                    pha                            ; use mask coming in
0610 CE88 A9 05 00              lda   #TheEvent
0611 CE8B 20 4B CE              jsr   PushDP
0612 CE8E A2 06 16 22           _GetOSEvent 
0613 CE95
0614 CE95 68                    pla   
0615 CE96
0616 CE96 60                    rts   
0617 CE97
0618 CE97                       eject 
0619 CE97              ;-------------------------------------------------
0620 CE97              ;
0621 CE97              ; DoDeskAcc
0622 CE97              ;
0623 CE97              ; Called when a desk accessory event is returned from 
0624 CE97              ; GetOSEvent. The desk accessory event occurs when
0625 CE97              ; the user has typed <ctrl><open-apple><esc>.
0626 CE97              ;
0627 CE97              ; When we get this message we call SystemEvent to
0628 CE97              ; handle it.
0629 CE97              ;
0630 CE97
0631 CE97              DoDeskAcc  
0632 CE97
0633 CE97 48                    pha                            ; space for result
0634 CE98 A2 13 00              ldx   #EvtModifiers            ; copy the contents of the event record, gotten
0635 CE9B B5 00        loop     lda   <0,x                     ; back from GetOSEvent as input to SystemEvent
0636 CE9D 48                    pha                            ; event record is on stack, which is also 
0637 CE9E CA                    dex                            ; currently our direct page
0638 CE9F CA                    dex   
0639 CEA0 E0 03 00              cpx   #EvtWhat-2               ; are we past beginning of event record?
0640 CEA3 D0 F6                 bne   loop
0641 CEA5 A2 05 1A 22           _SystemEvent 
0642 CEAC 68                    pla   
0643 CEAD 18                    clc   
0644 CEAE
0645 CEAE 60                    rts   
0646 CEAF
0647 CEAF
0648 CEAF                       eject 
0649 CEAF              ;-------------------------------------------------
0650 CEAF              ;
0651 CEAF              ; DoMouseDown
0652 CEAF              ;
0653 CEAF              ; Called when the mouse button goes down.
0654 CEAF              ;
0655 CEAF              ; Returns carry set if the mouse button goes back up inside
0656 CEAF              ; same button it went down in.  If carry is set then
0657 CEAF              ; a-reg has number of button.
0658 CEAF              ;
0659 CEAF              ; Modification History
0660 CEAF              ;
0661 CEAF              ; 31 Dec 86    SEG
0662 CEAF              ;
0663 CEAF              ;    Simple code reduction.  No changes in features.
0664 CEAF              ;
0665 CEAF
0666 CEAF              DoMouseDown                             ; 
0667 CEAF
0668 CEAF
0669 CEAF A9 0F 00              lda   #EvtWhere                ; figure out where it is
0670 CEB2 20 4B CE              jsr   PushDP
0671 CEB5 A2 04 85 22           _GlobalToLocal 
0672 CEBC
0673 CEBC A9 B9 D0              lda   #OKRect
0674 CEBF 20 47 CF              jsr   InRectLong
0675 CEC2 D0 0A                 bne   TrackOK
0676 CEC4
0677 CEC4 A9 B1 D0              lda   #CancelRect
0678 CEC7 20 47 CF              jsr   InRectLong
0679 CECA D0 0A                 bne   TrackCancel
0680 CECC
0681 CECC              Ignore                                  ; 
0682 CECC 18                    clc                            ; it was somewhere else
0683 CECD 60                    rts   
0684 CECE
0685 CECE
0686 CECE
0687 CECE              TrackOk                                 ; 
0688 CECE A0 B9 D0              ldy   #OKRect                  ; Put OKRect in HLRect
0689 CED1 A9 01 00              lda   #1                       ; this will be result later
0690 CED4 80 06                 bra   StartTracking
0691 CED6
0692 CED6              TrackCancel                             ; 
0693 CED6 A0 B1 D0              ldy   #CancelRect              ; Put CancelRect in HLRect
0694 CED9 A9 02 00              lda   #2
0695 CEDC
0696 CEDC              StartTracking                           ; 
0697 CEDC 85 4F                 sta   WhichButton
0698 CEDE A2 45 00              ldx   #HLRect
0699 CEE1 20 94 D0              jsr   MoveRect
0700 CEE4
0701 CEE4 A9 00 80     MakeDark lda   #$8000                   ; and setting this flag
0702 CEE7 85 4D                 sta   HiliteFlag
0703 CEE9 20 56 CF              jsr   DarkButton
0704 CEEC
0705 CEEC 48           CheckMouse pha                          ; space for result
0706 CEED F4 00 00              PushWord #0                    ; button 0
0707 CEF0 A2 06 0F 22           _WaitMouseUp 
0708 CEF7 68                    pla   
0709 CEF8 F0 2B                 beq   ItsNowUp                 ; false means yes it is now up.
0710 CEFA
0711 CEFA A9 0F 00              lda   #EvtWhere                ; its still down so check to see if
0712 CEFD 20 4B CE              jsr   PushDP
0713 CF00 A2 06 0C 22           _GetMouse                      ; it is still in the button
0714 CF07
0715 CF07 A9 45 00              lda   #HLRect
0716 CF0A 20 32 CF              jsr   InRectShort
0717 CF0D F0 06                 beq   NotIn
0718 CF0F
0719 CF0F A5 4D                 lda   HiliteFlag               ; Its in, check to see if but is still
0720 CF11 F0 D1                 beq   MakeDark                 ; dark, if not, light it
0721 CF13 80 D7                 bra   CheckMouse               ; otherwise try again.
0722 CF15
0723 CF15 A5 4D        NotIn    lda   HiliteFlag               ; Its not in, check to see but is dark
0724 CF17 D0 02                 bne   UnliteIt                 ; if yes, light it
0725 CF19 80 D1                 bra   CheckMouse
0726 CF1B
0727 CF1B A9 00 00     UnliteIt lda   #0
0728 CF1E 85 4D                 sta   HiliteFlag
0729 CF20 20 7A CF              jsr   LightButton
0730 CF23 80 C7                 bra   CheckMouse
0731 CF25
0732 CF25              ItsNowUp                                ; ; button came up so return lit state
0733 CF25 A5 4D                 lda   HiLiteFlag
0734 CF27 F0 07                 beq   Nevermind
0735 CF29
0736 CF29 20 7A CF              jsr   LightButton
0737 CF2C
0738 CF2C A5 4F                 lda   WhichButton              ; return button number
0739 CF2E 38                    sec                            ; signal end of secession
0740 CF2F 60                    rts   
0741 CF30
0742 CF30 18           NeverMind clc                           ; signal to continue
0743 CF31 60                    rts   
0744 CF32
0745 CF32
0746 CF32
0747 CF32                       eject 
0748 CF32              ;-------------------------------------------------
0749 CF32              ;
0750 CF32              ; InRect
0751 CF32              ;
0752 CF32              ; Returns whether or not the eventWhere point is
0753 CF32              ; in the rectangle passed in the a-reg
0754 CF32              ;
0755 CF32              ; The result is returned in the z flag.
0756 CF32              ;    z-set means that ptinrect returned false.
0757 CF32              ;    z-clear means that ptinrect returned true.
0758 CF32              ;
0759 CF32              ; Modification History
0760 CF32              ;
0761 CF32              ; 31 Dec 86    SEG
0762 CF32              ;
0763 CF32              ;    New this day.
0764 CF32              ;
0765 CF32
0766 CF32              InRectShort                             ; 
0767 CF32
0768 CF32 48                    pha                            ; space for result and save incoming
0769 CF33              ;                                       ; button.
0770 CF33 A9 0F 00              lda   #EvtWhere
0771 CF36 20 4B CE              jsr   PushDP
0772 CF39 A3 05                 lda   5,s
0773 CF3B 20 4B CE              jsr   PushDP
0774 CF3E A2 04 4F 22  JoinInRect _PtInRect 
0775 CF45 68                    pla   
0776 CF46 60                    rts   
0777 CF47
0778 CF47              InRectLong                              ; 
0779 CF47 48                    pha   
0780 CF48 A9 0F 00              lda   #EvtWhere
0781 CF4B 20 4B CE              jsr   PushDP
0782 CF4E A3 05                 lda   5,s
0783 CF50 F4 FD 00              PushWord #OKRect>>16 
0784 CF53 48                    pha   
0785 CF54 80 E8                 bra   JoinInRect
0786 CF56
0787 CF56                       eject 
0788 CF56              ;-------------------------------------------------
0789 CF56              ;
0790 CF56              ; DarkButton
0791 CF56              ;
0792 CF56              ; This is the routine that draws a hilited (dark) button.  It
0793 CF56              ; uses WhichButton to tell which to draw.
0794 CF56              ;
0795 CF56              ; Modification History
0796 CF56              ;
0797 CF56              ; 31 Dec 86    SEG
0798 CF56              ;
0799 CF56              ;    Simple code reduction.  No changes in features.
0800 CF56              ;
0801 CF56
0802 CF56              DarkButton                              ; 
0803 CF56
0804 CF56 20 A8 CF              jsr   PushHLStuff
0805 CF59 A2 04 5E 22           _PaintRRect 
0806 CF60
0807 CF60 F4 0F 00              PushWord #$000F 
0808 CF63 A2 04 A0 22           _SetForeColor 
0809 CF6A F4 00 00              PushWord #$0000 
0810 CF6D A2 04 A2 22           _SetBackColor 
0811 CF74
0812 CF74 A5 4F                 lda   WhichButton
0813 CF76 20 B7 CF              jsr   DrawButString
0814 CF79
0815 CF79 60                    rts   
0816 CF7A
0817 CF7A
0818 CF7A
0819 CF7A              ;-------------------------------------------------
0820 CF7A              ;
0821 CF7A              ; LightButton
0822 CF7A              ;
0823 CF7A              ; This is the routine that draws the normal
0824 CF7A              ; (unhilited) buttons. It uses WhichButton to
0825 CF7A              ; determine which to draw.
0826 CF7A              ;
0827 CF7A              ; Modification History
0828 CF7A              ;
0829 CF7A              ; 31 Dec 86    SEG
0830 CF7A              ;
0831 CF7A              ;    Simple code reduction.  No changes in
0832 CF7A              ;    features.
0833 CF7A              ;
0834 CF7A              ;
0835 CF7A              LightButton                             ; 
0836 CF7A
0837 CF7A 20 A8 CF              jsr   PushHLStuff
0838 CF7D A2 04 5F 22           _EraseRRect 
0839 CF84
0840 CF84 20 A8 CF              jsr   PushHLStuff
0841 CF87 A2 04 5D 22           _FrameRRect 
0842 CF8E
0843 CF8E F4 00 00              PushWord #$0000 
0844 CF91 A2 04 A0 22           _SetForeColor 
0845 CF98 F4 0F 00              PushWord #$000F 
0846 CF9B A2 04 A2 22           _SetBackColor 
0847 CFA2
0848 CFA2 A5 4F                 lda   WhichButton
0849 CFA4 20 B7 CF              jsr   DrawButString
0850 CFA7
0851 CFA7 60                    rts   
0852 CFA8
0853 CFA8
0854 CFA8                       eject 
0855 CFA8              ;-------------------------------------------------
0856 CFA8              ;
0857 CFA8              ; PushHLStuff
0858 CFA8              ;
0859 CFA8              ; Modification History
0860 CFA8              ;
0861 CFA8              ; 31 Dec 86    SEG
0862 CFA8              ;
0863 CFA8              ;    New this day.
0864 CFA8              ;
0865 CFA8
0866 CFA8              PushHLStuff                             ; 
0867 CFA8
0868 CFA8 7A                    ply   
0869 CFA9 A9 45 00              lda   #HLRect
0870 CFAC 20 4B CE              jsr   PushDP                   ; preserves y-reg
0871 CFAF F4 14 00              PushWord #20 
0872 CFB2 F4 0A 00              PushWord #10 
0873 CFB5 5A                    phy   
0874 CFB6 60                    rts   
0875 CFB7
0876 CFB7
0877 CFB7                       eject 
0878 CFB7              ;-------------------------------------------------
0879 CFB7              ;
0880 CFB7              ; DrawButString
0881 CFB7              ;
0882 CFB7              ; This routine draws the contents of a button.
0883 CFB7              ; The button to draw is passed in the a-reg
0884 CFB7              ;
0885 CFB7              ; Modification History
0886 CFB7              ;
0887 CFB7              ; 31 Dec 86    SEG
0888 CFB7              ;
0889 CFB7              ;    Simple code reduction.  No changes in features.
0890 CFB7              ;
0891 CFB7              ;
0892 CFB7              DrawButString                           ; 
0893 CFB7
0894 CFB7 C9 01 00              cmp   #1
0895 CFBA D0 2F                 bne   DoCancel
0896 CFBC
0897 CFBC 48                    pha                            ; figure string width to
0898 CFBD D4 5F                 pei   OKPtr+2                  ; center string in button
0899 CFBF D4 5D                 pei   OKPtr
0900 CFC1 A2 04 A9 22           _StringWidth 
0901 CFC8
0902 CFC8 A9 73 00              lda   #ButWidth
0903 CFCB 38                    sec   
0904 CFCC E3 01                 sbc   1,s
0905 CFCE 4A                    lsr   a
0906 CFCF 18                    clc                            ; add to left edge
0907 CFD0 6D BB D0              adc   OkRect+2
0908 CFD3 83 01                 sta   1,s                      ; push result
0909 CFD5 F4 35 00              PushWord #OKy 
0910 CFD8 A2 04 3A 22           _MoveTo 
0911 CFDF
0912 CFDF D4 5F                 pei   OkPtr+2                  ; draw ok string
0913 CFE1 D4 5D                 pei   OKPtr
0914 CFE3 A2 04 A5 22           _DrawString 
0915 CFEA
0916 CFEA 60                    rts   
0917 CFEB
0918 CFEB
0919 CFEB
0920 CFEB 48           DoCancel pha                            ; do it all again.
0921 CFEC D4 5B                 pei   CancelPtr+2
0922 CFEE D4 59                 pei   CancelPtr
0923 CFF0 A2 04 A9 22           _StringWidth 
0924 CFF7
0925 CFF7 A9 73 00              lda   #ButWidth
0926 CFFA 38                    sec   
0927 CFFB E3 01                 sbc   1,s
0928 CFFD 4A                    lsr   a
0929 CFFE 18                    clc   
0930 CFFF 6D B3 D0              adc   CancelRect+2
0931 D002 83 01                 sta   1,s
0932 D004 F4 35 00              PushWord #Cancely 
0933 D007 A2 04 3A 22           _MoveTo 
0934 D00E
0935 D00E D4 5B                 pei   CancelPtr+2
0936 D010 D4 59                 pei   CancelPtr
0937 D012 A2 04 A5 22           _DrawString 
0938 D019
0939 D019 60                    rts   
0940 D01A
0941 D01A                       eject 
0942 D01A              ;-------------------------------------------------
0943 D01A              ;
0944 D01A              ; DoKey
0945 D01A              ;
0946 D01A              ; This is the routine that checks key strokes
0947 D01A              ; for RETURN and ESC.
0948 D01A              ;
0949 D01A              ; It returns with carry set if either are
0950 D01A              ; pressed and the button number in the a-reg.
0951 D01A              ;
0952 D01A              ; If different key is pressed, it returns with
0953 D01A              ; carry clear.
0954 D01A              ;
0955 D01A              ; Modification History
0956 D01A              ;
0957 D01A              ; 31 Dec 86    SEG
0958 D01A              ;
0959 D01A              ;    Simple code reduction.  No changes in features.
0960 D01A              ;
0961 D01A
0962 D01A              DoKey                                   ; 
0963 D01A
0964 D01A
0965 D01A A5 07                 lda   EvtMessage               ; look at char typed.
0966 D01C C9 0D 00              cmp   #13                      ; RETURN = ok button
0967 D01F F0 07                 beq   OK
0968 D021
0969 D021 C9 1B 00              cmp   #27                      ; ESC = cancel button
0970 D024 F0 1A                 beq   Cancel
0971 D026
0972 D026
0973 D026 18                    clc                            ; bad key so signal that we must
0974 D027 60                    rts                            ; continue
0975 D028
0976 D028
0977 D028 A9 01 00     OK       lda   #1                       ; return result.
0978 D02B 85 4F                 sta   WhichButton
0979 D02D A0 B9 D0              ldy   #OKRect
0980 D030
0981 D030
0982 D030              FinishUp                                ; 
0983 D030 A2 45 00              ldx   #HLRect
0984 D033 20 94 D0              jsr   MoveRect
0985 D036 20 56 CF              jsr   DarkButton
0986 D039 20 7A CF              jsr   LightButton
0987 D03C A5 4F                 lda   WhichButton
0988 D03E 38                    sec   
0989 D03F 60                    rts   
0990 D040
0991 D040 A9 02 00     Cancel   lda   #2
0992 D043 85 4F                 sta   WhichButton
0993 D045 A0 B1 D0              ldy   #CancelRect
0994 D048 80 E6                 bra   FinishUp
0995 D04A
0996 D04A
0997 D04A                       eject 
0998 D04A              ;-------------------------------------------------
0999 D04A              ;
1000 D04A              ; DrawDialog
1001 D04A              ;
1002 D04A              ; This little routine draws the dialog.
1003 D04A              ;
1004 D04A              ; Modification History
1005 D04A              ;
1006 D04A              ; 31 Dec 86    SEG
1007 D04A              ;
1008 D04A              ;    Simple code reduction.  No changes in features.
1009 D04A              ;
1010 D04A
1011 D04A              DrawDialog                              ; 
1012 D04A
1013 D04A F4 0F 00              PushWord #PromptX              ; first put up the user's prompt
1014 D04D F4 0F 00              PushWord #PromptY 
1015 D050 A2 04 3A 22           _moveto 
1016 D057
1017 D057 D4 67                 pei   PromptPtr+2
1018 D059 D4 65                 pei   PromptPtr
1019 D05B A2 04 A5 22           _DrawString 
1020 D062
1021 D062 F4 0F 00              PushWord #VolX                 ; now the volume name
1022 D065 F4 1E 00              PushWord #VolY 
1023 D068 A2 04 3A 22           _MoveTo 
1024 D06F
1025 D06F D4 63                 pei   VolPtr+2
1026 D071 D4 61                 pei   VolPtr
1027 D073 A2 04 A5 22           _DrawString 
1028 D07A
1029 D07A A9 01 00              lda   #1
1030 D07D A0 B9 D0              ldy   #OKRect
1031 D080 20 89 D0              jsr   DrawAButton
1032 D083
1033 D083 A9 02 00              lda   #2
1034 D086 A0 B1 D0              ldy   #CancelRect
1035 D089
1036 D089              DrawAButton                             ; 
1037 D089 85 4F                 sta   WhichButton
1038 D08B A2 45 00              ldx   #HLRect
1039 D08E 20 94 D0              jsr   MoveRect
1040 D091 4C 7A CF              jmp   LightButton
1041 D094
1042 D094
1043 D094                       eject 
1044 D094              ;-------------------------------------------------
1045 D094              ;
1046 D094              ; MoveRect
1047 D094              ;
1048 D094              ; Moves 8 bytes from <<0,x to <<0,y.
1049 D094              ;
1050 D094
1051 D094              MoveRect                                ; 
1052 D094
1053 D094 B9 00 00              lda   |0,y
1054 D097 95 00                 sta   <0,x
1055 D099 B9 02 00              lda   |2,y
1056 D09C 95 02                 sta   <2,x
1057 D09E B9 04 00              lda   |4,y
1058 D0A1 95 04                 sta   <4,x
1059 D0A3 B9 06 00              lda   |6,y
1060 D0A6 95 06                 sta   <6,x
1061 D0A8
1062 D0A8 60                    rts   
1063 D0A9
1064 D0A9
1065 D0A9
1066 D0A9
1067 D0A9 00 00 00 00  DestRect DC W:0,0,DialogHeight,DialogWidth
1068 D0B1
1069 D0B1 2B 00        CancelRect DC W:DialogHeight-TopFace
1070 D0B3 0F 00                 DC W:LeftFace
1071 D0B5 38 00                 DC W:DialogHeight-TopFace+ButHeight
1072 D0B7 82 00                 DC W:LeftFace+ButWidth
1073 D0B9
1074 D0B9 2B 00        OKRect   DC W:DialogHeight-TopFace
1075 D0BB 96 00                 DC W:DialogWidth-LeftFace-ButWidth
1076 D0BD 38 00                 DC W:DialogHeight-TopFace+ButHeight
1077 D0BF 09 01                 DC W:DialogWidth-LeftFace
1078 D0C1
1079 D0C1
1080 D0C1
1081 D0C1                       ENDP 
1082 D0C1
1083 D0C1
1084 D0C1
1085 D0C1
1086 D0C1              ****************************************************************
1087 D0C1              *
1088 D0C1              TLTextMountVolume PROC EXPORT 
1089 D0C1              *
1090 D0C1              * This is the same call as TLMountVol except that it works in
1091 D0C1              * text rather than in super hires graphics.
1092 D0C1              *
1093 D0C1              * Assumptions:
1094 D0C1              *
1095 D0C1              *     1) The machine is already in text mode.
1096 D0C1              *     2) The text screen may be trashed.
1097 D0C1              *
1098 D0C1              * [3-Jun-91 DAL: Those assumptions are way out of date.  These
1099 D0C1              *  days it's calling SaveTextState and RestoreTextState.]
1100 D0C1              *
1101 D0C1              * This routine actually makes no OS calls.  It just returns
1102 D0C1              * the button number pressed by the user.  The application
1103 D0C1              * then can make the call that failed again and see if it
1104 D0C1              * works.
1105 D0C1              *
1106 D0C1              * By not guarenteeing the volume is mounted this routine is
1107 D0C1              * more general (and shorter).
1108 D0C1              *
1109 D0C1              *
1110 D0C1              *
1111 D0C1              * Inputs:
1112 D0C1              *              PromptPtr : long
1113 D0C1              *              VolPtr : long
1114 D0C1              *              OKPtr : long
1115 D0C1              *              CancelPtr : long
1116 D0C1              *
1117 D0C1              * Outputs:
1118 D0C1              *              ResultWord : word
1119 D0C1              *
1120 D0C1              * External Refs:
1121 D0C1                       import GoToXY 
1122 D0C1              *
1123 D0C1              * Entry Points:
1124 D0C1              *                   none
1125 D0C1              *
1126 D0C1                       longa on                       ; mode
1127 D0C1                       longi on
1128 D0C1              *
1129 D0C1              ****************************************************************
1130 D0C1
1131 D0C1
1132 D0C1              OrigDirect equ   1
1133 D0C1              RTL1     equ   OrigDirect+2
1134 D0C1              RTL2     equ   RTL1+3
1135 D0C1              CancelPtr equ   RTL2+3
1136 D0C1              OKPtr    equ   CancelPtr+4
1137 D0C1              VolPtr   equ   OKPtr+4
1138 D0C1              PromptPtr equ   VolPtr+4
1139 D0C1              Result   equ   PromptPtr+4
1140 D0C1
1141 D0C1
1142 D0C1              TextStartX equ   3
1143 D0C1              PromptLine equ   6
1144 D0C1              VolLine  equ   9
1145 D0C1              ButtonLine equ   13
1146 D0C1
1147 D0C1
1148 D0C1              ;-------------------------------------------------
1149 D0C1              ;
1150 D0C1              ; The event record is kept on real zero page
1151 D0C1              ; since this is saved and restored by this call.
1152 D0C1              ;
1153 D0C1                       DSect 0 
1154 D0C1              EvtWhat  word 
1155 D0C1              EvtMessage long 
1156 D0C1              EvtWhen  long 
1157 D0C1              EvtWhere long 
1158 D0C1              EvtModifiers word 
1159 D0C1              TheEvent equ   EvtWhat
1160 D0C1
1161 D0C1
1162 D0C1 0B                    phd   
1163 D0C2
1164 D0C2 3B                    tsc   
1165 D0C3 5B                    tcd   
1166 D0C4
1167 D0C4 8B                    phb   
1168 D0C5 4B                    phk   
1169 D0C6 AB                    plb   
1170 D0C7
1171 D0C7 48                    pha                            ; Save the current text screen
1172 D0C8 48                    pha                            ; environment
1173 D0C9 A2 01 13 22           _SaveTextState 
1174 D0D0
1175 D0D0 AF 36 00 00           lda   >CSWL                    ; save the input and output hooks
1176 D0D4 48                    pha   
1177 D0D5 AF 38 00 00           lda   >KSWL
1178 D0D9 48                    pha   
1179 D0DA
1180 D0DA 22 64 00 E1           jsl   IncBusyFlg
1181 D0DE
1182 D0DE F4 00 00              PushWord #0 
1183 D0E1 F4 00 00 F4           PushLong #3 
1184 D0E7 A2 0C 10 22           _SetOutputDevice 
1185 D0EE
1186 D0EE F4 00 00              PushWord #0 
1187 D0F1 F4 00 00 F4           PushLong #3 
1188 D0F7 A2 0C 0F 22           _SetInputDevice 
1189 D0FE
1190 D0FE F4 FF 00              PushWord #$FF 
1191 D101 F4 00 00              PushWord #0 
1192 D104 A2 0C 0A 22           _SetOutGlobals 
1193 D10B
1194 D10B F4 01 00              PushWord #1 
1195 D10E A2 0C 15 22           _InitTextDev 
1196 D115
1197 D115 F4 FD 00 F4           PushLong #Codes 
1198 D11B 22 66 D2 FD           jsl   ToWriteCString
1199 D11F
1200 D11F
1201 D11F 20 55 D2              jsr   DoBar
1202 D122
1203 D122 F4 20 00              PushWord #$20 
1204 D125 A2 0C 18 22           _WriteChar 
1205 D12C
1206 D12C A9 09 00              lda   #9
1207 D12F 48           BarLoop  pha   
1208 D130 E2 30                 sep   #$30
1209 D132                       longa off
1210 D132                       longi off
1211 D132 A9 27                 lda   #39
1212 D134 8F 24 00 00           sta   >$24
1213 D138 C2 30                 rep   #$30
1214 D13A                       longa on
1215 D13A                       longi on
1216 D13A F4 FD 00 F4           PushLong #Edges 
1217 D140 22 66 D2 FD           jsl   ToWriteCString
1218 D144 68                    pla   
1219 D145 3A                    dec   a
1220 D146 10 E7                 bpl   BarLoop
1221 D148
1222 D148 E2 30                 sep   #$30
1223 D14A                       longa off
1224 D14A                       longi off
1225 D14A A9 00                 lda   #0
1226 D14C 8F 24 00 00           sta   >$24
1227 D150 8F 7B 05 00           sta   >$57B
1228 D154 C2 30                 rep   #$30
1229 D156                       longa on
1230 D156                       longi on
1231 D156
1232 D156 20 55 D2              jsr   DoBar
1233 D159
1234 D159 F4 FF 00              PushWord #$FF 
1235 D15C F4 80 00              PushWord #$80 
1236 D15F A2 0C 0A 22           _SetOutGlobals 
1237 D166
1238 D166 A0 06 00              ldy   #PromptLine
1239 D169 A2 03 00              ldx   #TextStartX
1240 D16C 20 BC D2              jsr   GoToXY
1241 D16F
1242 D16F A5 17 48 A5           PushLong PromptPtr 
1243 D175 22 6E D2 FD           jsl   ToWriteString
1244 D179
1245 D179 A0 09 00              ldy   #VolLine
1246 D17C A2 03 00              ldx   #TextStartX
1247 D17F 20 BC D2              jsr   Gotoxy
1248 D182
1249 D182 A5 13 48 A5           PushLong VolPtr 
1250 D188 22 6E D2 FD           jsl   ToWriteString
1251 D18C
1252 D18C A0 0D 00              ldy   #ButtonLine
1253 D18F A2 03 00              ldx   #TextStartX
1254 D192 20 BC D2              jsr   Gotoxy
1255 D195
1256 D195 A5 0B 48 A5           PushLong CancelPtr 
1257 D19B 22 6E D2 FD           jsl   ToWriteString
1258 D19F
1259 D19F A7 0D                 lda   [OKPtr]
1260 D1A1 29 FF 00              and   #$00FF
1261 D1A4 48                    pha   
1262 D1A5 A9 26 00              lda   #40-TextStartX+1
1263 D1A8 E3 01                 sbc   1,s
1264 D1AA AA                    tax   
1265 D1AB 68                    pla   
1266 D1AC A0 0D 00              ldy   #ButtonLine
1267 D1AF 20 BC D2              jsr   Gotoxy
1268 D1B2
1269 D1B2 A5 0F 48 A5           PushLong OKPtr 
1270 D1B8 22 6E D2 FD           jsl   ToWriteString
1271 D1BC
1272 D1BC              NotESC                                  ; 
1273 D1BC
1274 D1BC              ;-----------------------------------------------------
1275 D1BC              ;
1276 D1BC              ; First try to read through the event manager
1277 D1BC              ;
1278 D1BC
1279 D1BC A9 2E 04              lda   #mDownMask+mUpMask+keyDownMask+autoKeyMask+deskAccMask
1280 D1BF 20 76 D2              jsr   GetThisEvent             ; call event manager
1281 D1C2 B0 32                 bcs   ReadMyself               ; if error then try to read status of keys yourself 
1282 D1C4
1283 D1C4 F0 F6                 beq   NotESC                   ; null event returned
1284 D1C6 AF 00 00 00           lda   >EvtWhat
1285 D1CA C9 03 00              cmp   #keyDownEvt              ; Is it a key down event?
1286 D1CD F0 21                 beq   ItsKeyDown
1287 D1CF C9 05 00              cmp   #autoKeyEvt
1288 D1D2 F0 1C                 beq   ItsKeyDown
1289 D1D4 C9 0A 00              cmp   #deskAccEvt              ; Is it a desk accessory event?
1290 D1D7 D0 E3                 bne   NotESC                   ; Neither keydown or deskacc so it must be a mouse down or
1291 D1D9              ;                                       ; mouse up which we'll just disregard.
1292 D1D9
1293 D1D9              ;
1294 D1D9              ; --- Call SystemEvent to handle calling the cda's ----------------------------------------
1295 D1D9              ;
1296 D1D9 48                    pha                            ; space for result
1297 D1DA A2 0E 00              ldx   #EvtModifiers            ; push all the values from the event record we got back
1298 D1DD BF 00 00 00  loop     lda   >0,x                     ; from GetOSEvent
1299 D1E1 48                    pha   
1300 D1E2 CA                    dex   
1301 D1E3 CA                    dex   
1302 D1E4 10 F7                 bpl   loop
1303 D1E6 A2 05 1A 22           _SystemEvent                   ; handle <ctrl><open-apple><esc>
1304 D1ED 68                    pla                            ; we don't care what we got back
1305 D1EE 80 CC                 bra   NotESC
1306 D1F0
1307 D1F0 AF 02 00 00  ItsKeyDown lda   >EvtMessage            ; Get ASCII character that was typed.
1308 D1F4 80 13                 bra   GotKey
1309 D1F6
1310 D1F6 E2 30        ReadMyself sep   #$30
1311 D1F8 AF 00 C0 E0           lda   $E0C000
1312 D1FC 10 04                 bpl   NoKey
1313 D1FE 8F 10 C0 E0           sta   $E0C010
1314 D202 C2 30        NoKey    rep   #$30
1315 D204 10 B6                 bpl   NotESC
1316 D206 29 7F 00              and   #$7F
1317 D209
1318 D209
1319 D209 C9 0D 00     GotKey   cmp   #13                      ; we only care about RETURN and ESC
1320 D20C D0 05                 bne   NotReturn
1321 D20E A9 01 00              lda   #1
1322 D211 80 08                 bra   Done
1323 D213
1324 D213 C9 1B 00     NotReturn cmp   #27
1325 D216 D0 A4                 bne   NotEsc
1326 D218 A9 02 00              lda   #2
1327 D21B
1328 D21B 85 19        Done     sta   Result
1329 D21D
1330 D21D
1331 D21D F4 01 00              PushWord #1                    ; clear screen again.
1332 D220 A2 0C 15 22           _InitTextDev 
1333 D227
1334 D227 68                    pla   
1335 D228 8F 38 00 00           sta   >KSWL                    ; input hook low
1336 D22C 68                    pla   
1337 D22D 8F 36 00 00           sta   >CSWL                    ; output hook low
1338 D231
1339 D231
1340 D231 A2 01 14 22           _RestoreTextState 
1341 D238
1342 D238
1343 D238 AB                    plb   
1344 D239
1345 D239
1346 D239 A0 10 00              ldy   #16
1347 D23C A2 00 00              ldx   #0
1348 D23F 2B                    pld   
1349 D240 5C 80 01 E1           jml   ToBusyStrip
1350 D244
1351 D244
1352 D244              NormalText                              ; 
1353 D244 E2 30                 sep   #$30
1354 D246                       longa off
1355 D246                       longi off
1356 D246 A9 FF                 lda   #$FF
1357 D248 8F 32 00 00  CommonText sta   >$32
1358 D24C C2 30                 rep   #$30
1359 D24E                       longa on
1360 D24E                       longi on
1361 D24E 60                    rts   
1362 D24F
1363 D24F              InverseText                             ; 
1364 D24F E2 30                 sep   #$30
1365 D251                       longa off
1366 D251                       longi off
1367 D251 A9 7F                 lda   #$7F
1368 D253 80 F3                 bra   CommonText
1369 D255                       longa on
1370 D255                       longi on
1371 D255
1372 D255              DoBar                                   ; 
1373 D255 20 4F D2              jsr   InverseText
1374 D258 F4 FD 00 F4           PushLong #Bar 
1375 D25E 22 66 D2 FD           jsl   ToWriteCString
1376 D262 20 44 D2              jsr   NormalText
1377 D265 60                    rts   
1378 D266
1379 D266              ToWriteCString                          ; 
1380 D266 A2 0C 20              ldx   #$200C
1381 D269 22 04 00 E1           jsl   $E10004
1382 D26D 6B                    rtl   
1383 D26E
1384 D26E              ToWriteString                           ; 
1385 D26E A2 0C 1A              ldx   #$1A0C
1386 D271 22 04 00 E1           jsl   $E10004
1387 D275 6B                    rtl   
1388 D276
1389 D276
1390 D276              ;-------------------------------------------------
1391 D276              ;
1392 D276              ; GetThisEvent
1393 D276              ;
1394 D276              ; Called to read character using event manager.
1395 D276              ;
1396 D276              ; Event mask is passed in a-reg.  boolean returned in a reg.
1397 D276              ;
1398 D276              GetThisEvent                            ; 
1399 D276 48                    pha                            ; space for result
1400 D277 48                    pha                            ; use mask coming in
1401 D278 F4 00 00 F4           PushLong #TheEvent 
1402 D27E A2 06 16 22           _GetOSEvent                    ; call GetOSEvent instead of GetNextEvent because we don't
1403 D285              ;                                       ; want keydowns to be passed onto the desk mgr
1404 D285 68                    pla   
1405 D286
1406 D286 60                    rts   
1407 D287
1408 D287
1409 D287
1410 D287 20 20 20 20  Bar      DC B:'                                        '
1411 D2AF              ;              1234567890123456789012345678901234567890
1412 D2AF 00                    DC B:0
1413 D2B0
1414 D2B0 20           Edges    DC B:$20
1415 D2B1 20                    DC B:$20
1416 D2B2 00                    DC B:0
1417 D2B3 5A                    DC B:$5A
1418 D2B4 5F                    DC B:$5F
1419 D2B5 00                    DC B:0
1420 D2B6
1421 D2B6
1422 D2B6 11 0D 0D 0D  Codes    DC B:17,13,13,13,13,0
1423 D2BC
1424 D2BC                       ENDP 
1425 D2BC
1426 D2BC
1427 D2BC              GoToXY   PROC 
1428 D2BC E2 30                 sep   #$30
1429 D2BE                       longa off
1430 D2BE                       longi off
1431 D2BE 8A                    txa                            ; long address
1432 D2BF 8F 24 00 00           sta   >$24
1433 D2C3 98                    tya   
1434 D2C4 8F 25 00 00           sta   >$25
1435 D2C8 C2 30                 rep   #$30
1436 D2CA                       longa on
1437 D2CA                       longi on
1438 D2CA A9 00 00              lda   #0
1439 D2CD 48                    pha   
1440 D2CE 48                    pha   
1441 D2CF 48                    pha   
1442 D2D0 48                    pha   
1443 D2D1 48                    pha   
1444 D2D2 48                    pha   
1445 D2D3 48                    pha   
1446 D2D4 F4 22 FC              PushWord #$FC22 
1447 D2D7 A2 03 24 22           _fwentry 
1448 D2DE 68                    pla   
1449 D2DF 68                    pla   
1450 D2E0 68                    pla   
1451 D2E1 68                    pla   
1452 D2E2 60                    rts   
1453 D2E3
1454 D2E3                       ENDP 
1455 D2E3
1456 D2E3                       title ' TLMemRoutines' 
1457 D2E3              ****************************************************************
1458 D2E3              *
1459 D2E3              TLMemRoutines2 PROC 
1460 D2E3              *
1461 D2E3              * Gets a handle of the size passed in the a-reg.  If GetMem
1462 D2E3              * is used, attributes are passed from calling routine in
1463 D2E3              * x-reg.  If TLNewhandle is used, attributes are TLAttributes.
1464 D2E3              *
1465 D2E3              *
1466 D2E3              * Inputs:
1467 D2E3              *    a-reg  Size of handle
1468 D2E3              *    x-reg  attributes of handle (for GetMem only)
1469 D2E3              *
1470 D2E3              * Outputs:
1471 D2E3              *    a-reg  Low word of handle (or error)
1472 D2E3              *    x-reg  high word of handle
1473 D2E3              *    carry  set on error, clear on success
1474 D2E3              *
1475 D2E3              * External Refs:
1476 D2E3              *                   none
1477 D2E3              *
1478 D2E3              * Entry Points:
1479 D2E3                       export TLGetMem2 
1480 D2E3                       entry TLNewHandle2 
1481 D2E3              *
1482 D2E3                       longa on                       ; mode
1483 D2E3                       longi on
1484 D2E3              *
1485 D2E3              * Change History
1486 D2E3              *
1487 D2E3              * 06 Oct 87    Steven Glass
1488 D2E3              *
1489 D2E3              *    Added.
1490 D2E3              *
1491 D2E3              * 17 Jun 88    Steven Glass
1492 D2E3              *
1493 D2E3              * Combined this with TLNewHandle.  Code was almost identical
1494 D2E3              * but duplicated.  By changing the calls to TLNewHandle to
1495 D2E3              * use the a-reg and x-reg for output we could share code.
1496 D2E3              *
1497 D2E3              ****************************************************************
1498 D2E3
1499 D2E3              TLNewHandle2  
1500 D2E3 A2 08 80              ldx   #TLAttributes
1501 D2E6              TLGetMem2  
1502 D2E6 48                    pha   
1503 D2E7 48                    pha   
1504 D2E8 F4 00 00              pea   $0000
1505 D2EB 48                    pha   
1506 D2EC F4 01 90              PushWord #TLUserID 
1507 D2EF DA                    phx   
1508 D2F0 48                    pha   
1509 D2F1 48                    pha   
1510 D2F2 A2 02 09 22           _NewHandle 
1511 D2F9 B0 03                 bcs   oops
1512 D2FB 68                    pla   
1513 D2FC FA                    plx   
1514 D2FD
1515 D2FD 60                    rts   
1516 D2FE
1517 D2FE FA           oops     plx   
1518 D2FF FA                    plx   
1519 D300 60                    rts   
1520 D301
1521 D301                       ENDP 
1522 D301
1523 D301
1524 D301                       END   
